/*******************************************************
Filename		:  act_medium.sql
Release 		:  c2.0
SIR			:  1443,1469,1513
Description		:  Creates the dimension table DI_ACTIVITY_MEDIUM and related objects.
Author			:  Joseph Wilson
Date			:  1/2/2003
			  03/13/2003 updated v2.0 Thieu
			  07/16/2003 updated to display all act mediums and bio fact table -JW
			  08/18/2003 declare rollback seg to use -JW
			  01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/
spool di_act_medium.log

drop table di_activity_medium;
create table di_activity_medium
(pk_isn number(12,0),
 activity_medium varchar2(20))
tablespace storetdata
storage (initial 500K next 500K)
nologging;

alter table di_activity_medium
add constraint pk_act_medium primary key (pk_isn)
using index
tablespace storetindx
storage (initial 100K next 100K);

/**
create bitmap index ire_activity_medium on FA_REGULAR_RESULT(activity_medium)
tablespace storetindx
storage (initial 15m next 15m)
nologging;
**/

--add data to di_activity_medium
insert into di_activity_medium values (1, 'Water');
insert into di_activity_medium values (2, 'Sediment');
insert into di_activity_medium values (3, 'Biological');
insert into di_activity_medium values (4, 'Soil');
insert into di_activity_medium values (5, 'Air');
insert into di_activity_medium values (6, 'Other');
commit;

create index iact_medium01 on di_activity_medium(activity_medium)
tablespace storetindx
storage (initial 100K next 100K)
nologging;


--update fks in FA_REGULAR_RESULT
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
UPDATE FA_REGULAR_RESULT RE SET FK_ACT_MEDIUM =
	(SELECT pk_isn	
	FROM di_activity_medium am
	WHERE re.activity_medium = am.activity_medium);
commit;

--update fks in FA_BIOLOGICAL_RESULT; set equal to Biology
UPDATE FA_BIOLOGICAL_RESULT RE SET FK_ACT_MEDIUM = 3;
commit;


--fks in FA_REGULAR_RESULT
--alter table FA_REGULAR_RESULT
--add constraint re_fk_act_medium foreign key (fk_act_medium) references di_activity_medium(pk_isn);

--indexes on fks in FA_REGULAR_RESULT
--changed to bitmap 1-30 
--? move to index script ?
create bitmap index ire_fk_act_medium on FA_REGULAR_RESULT(fk_act_medium)
tablespace storetindx
storage (initial 15m next 15m)
nologging;

-- moved the drop columns statement.

spool off;